#include <algorithm>
#include <cstdio>
#include <vector>

int n, s;

int main(void) {
  scanf("%d%d", &n, &s);
  std::vector<std::pair<int, int>> E;
  for (int i = 0; i < n; ++i) {
    int h1, m1, s1;
    int h2, m2, s2;
    scanf("%d:%d:%d %d:%d:%d", &h1, &m1, &s1, &h2, &m2, &s2);
    int t1 = h1 * 3600 + m1 * 60 + s1, t2 = h2 * 3600 + m2 * 60 + s2;
    int dist = (t1 - t2 + 24 * 3600 - 1) % (24 * 3600);

    t1 -= std::min(s, dist);
    if (t1 < 0) {
      t1 += 24 * 3600;
    }
    E.push_back(std::make_pair(t1, t2));
  }

  int sol = 1 << 30;
  for (auto e : E) {
    std::vector<std::pair<int, int>> I;
    for (auto ex : E) {
      int t1 = ex.first - e.first;
      int t2 = ex.second - e.first;
      if (t1 < 0) t1 += 24 * 3600;
      if (t2 < 0) t2 += 24 * 3600;
      if (t1 > t2) t2 += 24 * 3600;
      I.push_back({t1, t2});
    }

    sort(I.begin(), I.end(), [](std::pair<int, int> a, std::pair<int, int> b) {
      return a.second < b.second;
    });

    int last = -10;
    int curr = 0;
    for (auto ex : I) {
      if (last < ex.first) {
        ++curr;
        last = ex.second;
      }
    }
    sol = std::min(sol, curr);
  }

  printf("%d\n", sol);
  return 0;
}
